﻿//Library Name: cvt_QualityCheck.OnChange.js
//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.QualityCheck_OnChange = {};

//Make Flag mandatory based on Status Reason Submitted
MCS.QualityCheck_OnChange.FlagStatusReason = function () {
    var statusReason = (Xrm.Page.getAttribute('statuscode').getValue() != null) ? Xrm.Page.getAttribute('statuscode').getSelectedOption().value : null;
    var typeOfPrivileging = null;

    /*
    Draft	    1
    Submitted	917290000
    Inactive	0
    */
    var thisrecord = Xrm.Page.data.entity.getId();
    switch (statusReason) {
        case 917290000: //Submitted
            //Should we verify there are KPI records?

            //Search for child records with red flag
            var filter = "statuscode/Value eq 1 and cvt_QualityCheckId/Id eq (Guid'" + thisrecord + "') and cvt_Flag/Value eq 917290001";
            CrmRestKit.ByQuery("cvt_kpi", ['cvt_Indicator', 'cvt_kpiId'], filter, true)
            .fail(function (error) {
                //return;
            })
            .done(function (redFlagData) {
                //Successful query on conflict search
                if (redFlagData && redFlagData.d.results && redFlagData.d.results.length > 0) {
                    //Results, therefore RED
                    //alert('Flag is set to Red because a KPI is flagged Red.');
                    Xrm.Page.getAttribute("cvt_flag").setValue(917290001);
                    Xrm.Page.getAttribute("cvt_flag").setSubmitMode('always');

                    //Refresh the WebResource
                    var wrControl = Xrm.Page.ui.controls.get("WebResource_KPIform");
                    wrControl.setSrc(wrControl.getSrc());
                }
                else { //Set to Green
                    Xrm.Page.getAttribute("cvt_flag").setValue(917290000);
                    Xrm.Page.getAttribute("cvt_flag").setSubmitMode('always');

                    //Refresh the WebResource
                    var wrControl = Xrm.Page.ui.controls.get("WebResource_KPIform");
                    wrControl.setSrc(wrControl.getSrc());
                }
            });
    }
};

//Description: TSS Privileging Lookup and set Facility
MCS.QualityCheck_OnChange.TSSPrivLookup = function () {
    var statusReason = null;
    if (Xrm.Page.getAttribute('cvt_tssprivilegingid').getValue() != null) {
        privLookup = Xrm.Page.getAttribute('cvt_tssprivilegingid').getValue()[0].id;
    }
    else {
        return;
    }

    var calls = CrmRestKit.Retrieve("cvt_tssprivileging", privLookup, ['cvt_PrivilegedAtId', 'cvt_ProviderId'], false);
    calls.fail(
            function (error) {
    }).done(function (data) {
        if (data && data.d) {
            //Check and Set Facility
            var value = new Array();
            value[0] = new Object();
            value[0].id = '{' + data.d.cvt_PrivilegedAtId.Id + '}';
            value[0].name = data.d.cvt_PrivilegedAtId.Name;
            value[0].entityType = "mcs_facility";

            var providervalue = new Array();
            providervalue[0] = new Object();
            providervalue[0].id = '{' + data.d.cvt_ProviderId.Id + '}';
            providervalue[0].name = data.d.cvt_ProviderId.Name;
            providervalue[0].entityType = "systemuser";

            Xrm.Page.data.entity.attributes.get('cvt_facilityid').setSubmitMode('always');
            Xrm.Page.data.entity.attributes.get('cvt_facilityid').setValue(value);

            Xrm.Page.data.entity.attributes.get('cvt_providerid').setSubmitMode('always');
            Xrm.Page.data.entity.attributes.get('cvt_providerid').setValue(providervalue);
        }
    });
};